<!-- Page CSS -->
<?php $__env->startSection('pageStyle'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/page-profile.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content -->

<div class="container-xxl flex-grow-1 container-p-y">

    <h4 class="fw-bold py-3 mb-4 px-3">
        <span class="text-muted fw-light"><a
                href="<?php echo e(route($parent_named_route.'.index')); ?>"><?php echo e($module_name); ?></a>
            /</span> <?php echo e(ucfirst($page)); ?>

    </h4>

    <!-- Header -->
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="user-profile-header-banner">
                    <img src="../../assets/img/pages/profile-banner.png" alt="Banner image" class="rounded-top">
                </div>
                <div class="user-profile-header d-flex flex-column flex-sm-row text-sm-start text-center mb-4">
                    <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                        <img src="<?php echo e($club->logo); ?>" alt="user image"
                            class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img">
                    </div>
                    <div class="flex-grow-1 mt-3 mt-sm-5">
                        <div
                            class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-4 flex-md-row flex-column gap-4">
                            <div class="user-profile-info">
                                <h4><?php echo e($club->name); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Header -->

    <!-- User Profile Content -->
    <div class="row">
        <div class="col-xl-4 col-lg-5 col-md-5">
            <!-- About User -->
            <div class="card mb-4">
                <div class="card-body">
                    <small class="text-muted text-uppercase">About</small>
                    <ul class="list-unstyled mb-4 mt-3">
                        <li class="d-flex align-items-center mb-3"><i class="bx bx-user"></i><span
                                class="fw-semibold mx-2">Club Name:</span> <span><?php echo e($club->name); ?></span>
                        </li>
                        <li class="d-flex align-items-center mb-3"><i class="bx bx-check"></i><span
                                class="fw-semibold mx-2">Status:</span>
                            <span><?php echo e($club->status ? 'Active' : 'Inactive'); ?></span>
                        </li>
                        <li class="d-flex align-items-center mb-3"><i class="bx bx-star"></i><span
                                class="fw-semibold mx-2">Creator:</span>
                            <span><?php echo e(ucfirst($club->user->name)); ?></span>
                        </li>
                    </ul>
                    <small class="text-muted text-uppercase">Creator Contacts</small>
                    <ul class="list-unstyled mb-4 mt-3">
                        <li class="d-flex align-items-center mb-3"><i class="bx bx-phone"></i><span
                                class="fw-semibold mx-2">Contact:</span> <span><?php echo e($club->user->phone); ?></span>
                        </li>
                        <li class="d-flex align-items-center mb-3"><i class="bx bx-envelope"></i><span
                                class="fw-semibold mx-2">Creator Email:</span>
                            <span><?php echo e($club->user->email); ?></span></li>
                    </ul>
                </div>
            </div>
            <!--/ About User -->
            <!-- Profile Overview -->
            <div class="card mb-4">
                  <div class="card-body">
                    <div>
                        <small class="text-muted text-uppercase">Features</small>
                        <ul class="list-unstyled mt-3 mb-0">
                            <?php if(count($club->features) > 0 ): ?>
                            <?php $__currentLoopData = $club->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="d-flex align-items-center mb-3"><i class="bx bx-check"></i><span
                                    class="fw-semibold mx-2"><?php echo e($feature->name); ?>:</span>
                                <span><?php echo e(handleBooleanStatus($feature->status)); ?></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <p>No Feature Listed</p>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <?php
                    $amenities = json_decode($club->amenities, true);
                    $surfaces = json_decode($club->surfaces, true);
                    $nets = json_decode($club->nets, true);
                    ?>

                    <div>
                        <small class="text-muted text-uppercase">Amenities</small>

                        <ul class="list-unstyled mt-3 mb-0">
                            <?php if(!empty($amenities) && is_array($amenities)): ?>
                            <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="d-flex align-items-center mb-3">
                                <i class="bx bx-check"></i>
                                <span class="fw-semibold mx-2"><?php echo e($amenity); ?></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <p>No Amenities Listed</p>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <div>
                        <small class="text-muted text-uppercase">Surface and Features</small>

                        <ul class="list-unstyled mt-3 mb-0">
                            <?php if(!empty($surfaces) && is_array($surfaces)): ?>
                            <?php $__currentLoopData = $surfaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $surface): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="d-flex align-items-center mb-3">
                                <i class="bx bx-check"></i>
                                <span class="fw-semibold mx-2"><?php echo e($surface); ?></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <p>No Surface and Feature Listed</p>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <div>
                        <small class="text-muted text-uppercase">Nets and Line</small>

                        <ul class="list-unstyled mt-3 mb-0">
                            <?php if(!empty($nets) && is_array($nets)): ?>
                            <?php $__currentLoopData = $nets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $net): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="d-flex align-items-center mb-3">
                                <i class="bx bx-check"></i>
                                <span class="fw-semibold mx-2"><?php echo e($net); ?></span>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <p>No Nets and Line Listed</p>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <!--/ Profile Overview -->
        </div>
        <div class="col-md-12 col-lg-8 order-4 order-lg-3 ">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="card-title m-0 me-2">Tournaments Timeline</h5>
                </div>
                <div class="card-body">
                    <!-- Tournaments Timeline -->
                    <ul class="timeline">
                        <?php if(count($club->tournaments) > 0): ?>
                            <?php $__currentLoopData = $club->tournaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tournament): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="timeline-item timeline-item-transparent">
                                    <span class="timeline-point timeline-point-primary"></span>
                                    <div class="timeline-event">
                                        <div class="timeline-header mb-1">
                                            <h6 class="mb-0"><?php echo e($tournament->name); ?></h6>
                                            <small class="text-muted">Start Date:
                                                <?php echo e(customDateFormat($tournament->start_date)); ?></small>
                                            <small class="text-muted">End Date:
                                                <?php echo e(customDateFormat($tournament->end_date)); ?></small>
                                        </div>
                                        <p class="mb-2"><?php echo e($tournament->description); ?></p>
                                        <div class="d-flex">
                                            <a href="javascript:void(0)" class="d-flex align-items-center me-3">
                                                <img src="<?php echo e($club->logo); ?>" alt="PDF image" width="23" class="me-2">
                                                <h6 class="mb-0"><?php echo e($tournament->slug); ?></h6>
                                            </a>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <p>No tournament yet</p>
                        <?php endif; ?>
                    </ul>
                    <!-- /Tournaments Timeline -->
                </div>
            </div>
        </div>
    </div>
    <!--/ User Profile Content -->
</div>
<!-- / Content -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/pages-profile')); ?>"></script>
<?php $__env->stopSection(); ?>

<!-- Page JS -->

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/democmolds1/public_html/projects/pblink_admin_2024/resources/views/pages/club/view.blade.php ENDPATH**/ ?>