<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-primary alert-dismissible" role="alert">
    <?php echo e(session('success')); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
</div>
<?php endif; ?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4 px-3">
            <span class="text-muted fw-light"><a
                    href="<?php echo e(route($parent_named_route.'.index')); ?>"><?php echo e($module_name); ?></a>
                /</span> Edit
        </h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="card-body">
                        <form action="<?php echo e(route('reservations.edit', ['id' => $reservation->id])); ?>" class="mb-3" method="POST">
                            <?php echo csrf_field(); ?>
                            <div>
                                <label for="defaultFormControlInput" class="form-label">Club</label>
                                <select name="club_id" class="form-control" id="defaultFormControlInput" aria-describedby="defaultFormControlHelp">
                                    <?php $__currentLoopData = $clubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $club): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($club->id); ?>" <?php echo e($reservation->club_id == $club->id ? 'selected' : ''); ?>><?php echo e($club->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">Reservation Date</label>
                                <input
                                    name="reservation_date"
                                    type="date"
                                    class="form-control"
                                    value="<?php echo e($reservation->reservation_date ? $reservation->reservation_date->format('Y-m-d') : ''); ?>"
                                    aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('reservation_date')): ?>
                                <span class="text-danger"><?php echo e($errors->first('reservation_date')); ?></span>
                                <?php endif; ?>
                            </div>

                            <div>
                                <label for="longitudeInput" class="form-label">Start Time</label>
                                <input
                                    name="start_time"
                                    type="time"
                                    class="form-control"
                                    value="<?php echo e($reservation->start_time ? $reservation->start_time->format('H:i') : ''); ?>"
                                    aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('start_time')): ?>
                                <span class="text-danger"><?php echo e($errors->first('start_time')); ?></span>
                                <?php endif; ?>
                            </div>

                            <div>
                                <label for="longitudeInput" class="form-label">End Time</label>
                                <input
                                    name="end_time"
                                    type="time"
                                    class="form-control"
                                    id="longitudeInput"
                                    value="<?php echo e($reservation->end_time ? $reservation->end_time->format('H:i') : ''); ?>"
                                    aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('end_time')): ?>
                                <span class="text-danger"><?php echo e($errors->first('end_time')); ?></span>
                                <?php endif; ?>
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">Day</label>
                                <select name="day" class="form-control" id="defaultFormControlInput" aria-describedby="defaultFormControlHelp">
                                    <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php echo e($reservation->day == $key ? 'selected' : ''); ?>><?php echo e($day); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            
                            <div>
                                <label for="defaultFormControlInput" class="form-label">Status</label>
                                <select name="status" class="form-control" id="defaultFormControlInput" aria-describedby="defaultFormControlHelp">
                                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php echo e($reservation->status == $key ? 'selected' : ''); ?>><?php echo e($status); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="demo-inline-spacing">
                                <input type="submit" class="btn btn-primary move-right" value="Update" />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('scripts'); ?>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/democmolds1/public_html/projects/pblink_admin_2024/resources/views/pages/reservation/edit.blade.php ENDPATH**/ ?>