
<!-- Include Tagify CSS & JS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@yaireo/tagify/dist/tagify.css">
<script src="https://cdn.jsdelivr.net/npm/@yaireo/tagify"></script>

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-primary alert-dismissible" role="alert">
    <?php echo e(session('success')); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
</div>
<?php endif; ?>
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4 px-3">
            <span class="text-muted fw-light"><a
                    href="<?php echo e(route($parent_named_route.'.index')); ?>"><?php echo e($module_name); ?></a>
                /</span> Edit
        </h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="card-body">
                        <form action="<?php echo e(route('clubs.edit', ['id' => $club->id])); ?>" class="mb-3" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div>
                                <label for="defaultFormControlInput" class="form-label">name</label>
                                <input name="name" type="text" class="form-control" id="defaultFormControlInput"
                                    placeholder="Club Name" value="<?php echo e($club->name); ?>" aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('name')): ?>
                                <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                                <?php endif; ?>
                            </div>
                            <div>
                                <label for="defaultFormControlInput" class="form-label">logo</label>
                                <input name="logo" type="file" class="form-control" id="defaultFormControlInput"
                                    placeholder="New York" value="<?php echo e($club->logo); ?>" aria-describedby="defaultFormControlHelp" />
                                <img src="<?php echo e($club->logo); ?>" height="50px" width="100px">
                                <span class="text-info"><?php echo e(str_replace(env('UPLOAD_URL').'clubs/', '', $club->logo)); ?></span>
                                <?php if($errors->has('logo')): ?>
                                <span class="text-danger"><?php echo e($errors->first('logo')); ?></span>
                                <?php endif; ?>
                            </div>

                            <!-- jQuery (optional, only needed for the Enter key prevention script) -->
                            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

                            <!-- Google Maps JavaScript API -->
                            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBAY9jgE-CPAPcU78LqNJ6xquCX01LNcp4&libraries=places&callback=initialize" async> </script>
                            <script>
                                $(document).ready(function() {
                                    $(window).keydown(function(event) {
                                        if (event.keyCode === 13) {
                                            event.preventDefault();
                                            return false;
                                        }
                                    });
                                });

                                let map, marker, autocomplete;

                                function initialize() {
                                    initMap();
                                    initAutocomplete();
                                }

                                function initMap() {
                                    map = new google.maps.Map(document.getElementById('map'), {
                                        center: {
                                            lat: 40.749933,
                                            lng: -73.98633
                                        },
                                        zoom: 13
                                    });
                                }

                                function initAutocomplete() {
                                    autocomplete = new google.maps.places.Autocomplete(
                                        document.getElementById('autocomplete'), {
                                            types: ['geocode']
                                        }
                                    );
                                    autocomplete.addListener('place_changed', fillInAddress);
                                }

                                function fillInAddress() {
                                    const place = autocomplete.getPlace();
                                    if (!place.geometry) return;

                                    // Update map
                                    if (place.geometry.viewport) {
                                        map.fitBounds(place.geometry.viewport);
                                    } else {
                                        map.setCenter(place.geometry.location);
                                        map.setZoom(17);
                                    }

                                    if (marker) {
                                        marker.setMap(null);
                                    }

                                    marker = new google.maps.Marker({
                                        map: map,
                                        position: place.geometry.location
                                    });

                                    document.getElementById("latitude").value = place.geometry.location.lat();
                                    document.getElementById("longitude").value = place.geometry.location.lng();
                                    // document.getElementById("map").removeAttribute("hidden");
                                }

                                function geolocate() {
                                    if (navigator.geolocation) {
                                        navigator.geolocation.getCurrentPosition(function(position) {
                                            const geolocation = {
                                                lat: position.coords.latitude,
                                                lng: position.coords.longitude
                                            };
                                            const circle = new google.maps.Circle({
                                                center: geolocation,
                                                radius: position.coords.accuracy
                                            });
                                            autocomplete.setBounds(circle.getBounds());
                                        });
                                    }
                                }
                            </script>

                            <div class="mb-3">
                                <label for="" class="form-label">location</label>
                                <input class="form-control"
                                    value="<?php echo e($club->location); ?>"
                                    type="text"
                                    name="location"
                                    id="autocomplete"
                                    onFocus="geolocate()"
                                    placeholder="Club Location"
                                    data-parsley-required-message="The restaurant address field is required"
                                    required>
                                <?php if($errors->has('location')): ?>
                                <span class="text-danger"><?php echo e($errors->first('location')); ?></span>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <input class="form-control"
                                    type="hidden"
                                    name="latitude"
                                    id="latitude"
                                    placeholder="Latitude"
                                    required>
                            </div>

                            <div class="mb-3">
                                <input class="form-control"
                                    type="hidden"
                                    name="longitude"
                                    id="longitude"
                                    placeholder="Longitude"
                                    required>
                            </div>

                            <!-- Map Display -->
                            <div id="map" hidden style="width:100%;height:400px;"></div>
                            <!-- <div>
                                <label for="defaultFormControlInput" class="form-label">location</label>
                                <input name="location" type="text" class="form-control" id="defaultFormControlInput"
                                    placeholder="New York" value="<?php echo e($club->location); ?>" aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('location')): ?>
                                <span class="text-danger"><?php echo e($errors->first('location')); ?></span>
                                <?php endif; ?>
                            </div> -->

                            <div>
                                <label for="defaultFormControlInput" class="form-label">State</label>
                                <input name="state" type="text" class="form-control" id="defaultFormControlInput"
                                    placeholder="Enter State" value="<?php echo e($club->state); ?>" aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('state')): ?>
                                <span class="text-danger"><?php echo e($errors->first('state')); ?></span>
                                <?php endif; ?>
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">City</label>
                                <input name="city" type="text" class="form-control" id="defaultFormControlInput"
                                    placeholder="Enter City" value="<?php echo e($club->city); ?>" aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('city')): ?>
                                <span class="text-danger"><?php echo e($errors->first('city')); ?></span>
                                <?php endif; ?>
                            </div>

                            <!-- <div>
                                <label for="latitudeInput" class="form-label">Latitude</label>
                                <input name="latitude" type="text" class="form-control" id="latitudeInput"
                                    placeholder="37.7749" value="<?php echo e($club->latitude); ?>" aria-describedby="latitudeHelp"
                                    inputmode="decimal" pattern="^-?\d+(\.\d+)?$" />
                                <?php if($errors->has('latitude')): ?>
                                <span class="text-danger"><?php echo e($errors->first('latitude')); ?></span>
                                <?php endif; ?>
                            </div>
                            <div>
                                <label for="longitudeInput" class="form-label">Longitude</label>
                                <input name="longitude" type="text" class="form-control" id="longitudeInput"
                                    placeholder="-122.4194" value="<?php echo e($club->longitude); ?>" aria-describedby="defaultFormControlHelp"
                                    inputmode="decimal" pattern="^-?\d+(\.\d+)?$" />
                                <?php if($errors->has('longitude')): ?>
                                <span class="text-danger"><?php echo e($errors->first('longitude')); ?></span>
                                <?php endif; ?>
                            </div> -->

                            <div>
                                <label for="exampleFormControlTextarea1" class="form-label">Description</label>
                                <textarea name="description" class="form-control" id="exampleFormControlTextarea1"
                                    rows="3" placeholder="We are please to announce that..."><?php echo e($club->description); ?></textarea>
                                <?php if($errors->has('description')): ?>
                                <span
                                    class="text-danger"><?php echo e($errors->first('description')); ?></span>
                                <?php endif; ?>
                            </div>

                            <?php
                            $amenities = json_decode($club->amenities, true);
                            $surfaces = json_decode($club->surfaces, true);
                            $nets = json_decode($club->nets, true);
                            ?>

                            <div class="mb-3">
                                <label for="amenities" class="form-label">Amenities</label>
                                <input class="form-control" name="amenities" id="amenities"
                                    placeholder="Type and press enter"
                                    value="<?php echo e(old('amenities', is_array($amenities) ? implode(',', $amenities) : '')); ?>" />
                            </div>

                            <div class="mb-3">
                                <label for="surface" class="form-label">Surface and Features</label>
                                <input class="form-control" name="surface" id="surface"
                                    placeholder="Type and press enter"
                                    value="<?php echo e(old('surface', is_array($surfaces) ? implode(',', $surfaces) : '')); ?>" />
                            </div>

                            <div class="mb-3">
                                <label for="net" class="form-label">Net and Lines</label>
                                <input class="form-control" name="net" id="net"
                                    placeholder="Type and press enter"
                                    value="<?php echo e(old('net', is_array($nets) ? implode(',', $nets) : '')); ?>" />
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">Total Courts</label>
                                <input name="total_courts" type="number" class="form-control" id="defaultFormControlInput"
                                    placeholder="4" value="<?php echo e($club->total_courts); ?>" aria-describedby="defaultFormControlHelp" />
                                <?php if($errors->has('total_courts')): ?>
                                <span class="text-danger"><?php echo e($errors->first('total_courts')); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="demo-inline-spacing">
                                <input type="submit" class="btn btn-primary move-right" value="Update" />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('scripts'); ?>
    <script>
        document.getElementById('latitudeInput').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9.-]/g, '');
        });

        document.getElementById('longitudeInput').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9.-]/g, '');
        });
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            new Tagify(document.querySelector('#amenities'));
            new Tagify(document.querySelector('#surface'));
            new Tagify(document.querySelector('#net'));
        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/democmolds1/public_html/projects/pblink_admin_2024/resources/views/pages/club/edit.blade.php ENDPATH**/ ?>