@extends('layouts.master')

@section('content')
@if(session('success'))
<div class="alert alert-primary alert-dismissible" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
</div>
@endif
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4 px-3">
            <span class="text-muted fw-light"><a
                    href="{{ route($parent_named_route.'.index') }}">{{ $module_name }}</a>
                /</span> Add
        </h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="card-body">
                        <form action="{{ route($parent_named_route.'.create') }}" class="mb-3" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div>
                                <label for="defaultFormControlInput" class="form-label">title</label>
                                <input name="title" type="text" class="form-control" id="defaultFormControlInput"
                                    placeholder="Title" value="" aria-describedby="defaultFormControlHelp" />
                                @if($errors->has('title'))
                                <span class="text-danger">{{ $errors->first('title') }}</span>
                                @endif
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">type</label>
                                <input name="type" type="text" class="form-control" id="defaultFormControlInput"
                                    placeholder="Type" value="" aria-describedby="defaultFormControlHelp" />
                                @if($errors->has('type'))
                                <span class="text-danger">{{ $errors->first('type') }}</span>
                                @endif
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">amount</label>
                                <input name="amount" type="number" class="form-control" id="defaultFormControlInput"
                                    placeholder="15" value="" aria-describedby="defaultFormControlHelp" />
                                @if($errors->has('amount'))
                                <span class="text-danger">{{ $errors->first('amount') }}</span>
                                @endif
                            </div>

                            <div>
                                <label for="defaultFormControlInput" class="form-label">duration</label>
                                <input name="duration" type="number" class="form-control" id="defaultFormControlInput"
                                    placeholder="15" value="" aria-describedby="defaultFormControlHelp" />
                                @if($errors->has('duration'))
                                <span class="text-danger">{{ $errors->first('duration') }}</span>
                                @endif
                            </div>

                            <div>
                                <label for="exampleFormControlTextarea1" class="form-label">Description</label>
                                <textarea name="description" class="form-control" id="exampleFormControlTextarea1"
                                    rows="3" placeholder="This plan offers..."></textarea>
                                @if($errors->has('description'))
                                <span
                                    class="text-danger">{{ $errors->first('description') }}</span>
                                @endif
                            </div>

                            <div class="demo-inline-spacing">
                                <input type="submit" class="btn btn-primary move-right" value="Add" />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->
    @endsection

    @section('scripts')
    @endsection