@extends('layouts.master')
@section('contain')
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">Subscription Management</div>
                <div class="ps-3">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0 p-0">
                            <li class="breadcrumb-item"><a href="{{ url('/') }}"><i class="bx bx-home-alt"></i></a></li>
                            <li class="breadcrumb-item active" aria-current="page">Subscription Management</li>
                        </ol>
                    </nav>
                </div>
            </div>

            <!--end breadcrumb-->
            <hr />
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="subscriptionTable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>User Name</th>
                                    <th>Package</th>
                                    <th>Package Type</th>
                                    <th>amount</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- DataTable content will be loaded dynamically here -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
       $(document).ready(function () {
    $('#subscriptionTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('subscription.index') }}",
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false },
            { data: 'user.full_name', name: 'user.full_name' },
            { data: 'plan.title', name: 'plan.title', defaultContent: 'N/A' }, // Handle missing plans
            { data: 'plan.type', name: 'plan.type', defaultContent: 'N/A' },
            { data: 'amount', name: 'amount' },
            {
                data: 'start_date',
                name: 'start_date',
                render: function(data) {
                    return data ? moment(data).format('YYYY-MM-DD') : 'N/A';
                }
            },
            {
                data: 'end_date',
                name: 'end_date',
                render: function(data) {
                    return data ? moment(data).format('YYYY-MM-DD') : 'N/A';
                }
            }
        ]
    });
});


    </script>
@endsection
