@extends('layouts.master')

@section('title', 'My Courts')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <!-- Header with Stats -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <h4 class="py-3 mb-0">
                        <span class="text-muted fw-light">Courts /</span> All Courts
                    </h4>
                    <p class="text-muted mb-0">View and manage all court listings</p>
                </div>
                <div>
                    <a href="{{ route('courts.create-advanced') }}" class="btn btn-primary">
                        <i class="bx bx-plus me-2"></i>Add New Court
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text text-muted">Total Courts</p>
                            <div class="d-flex align-items-end mb-2">
                                <h4 class="card-title mb-0 me-2">{{ $total_courts ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-primary rounded p-2">
                                <i class="bx bx-building text-primary"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text text-muted">Active Courts</p>
                            <div class="d-flex align-items-end mb-2">
                                <h4 class="card-title mb-0 me-2 text-success">{{ $active_courts ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-success rounded p-2">
                                <i class="bx bx-check-circle text-success"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-lg-6 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text text-muted">Inactive Courts</p>
                            <div class="d-flex align-items-end mb-2">
                                <h4 class="card-title mb-0 me-2 text-warning">{{ $inactive_courts ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-warning rounded p-2">
                                <i class="bx bx-pause-circle text-warning"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Courts Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">All Courts</h5>
            <div class="card-action">
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="bx bx-filter me-1"></i>Filter
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="filterByStatus('all')">All Courts</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="filterByStatus('active')">Active Only</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="filterByStatus('inactive')">Inactive Only</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="myCourtsList">
                                            <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Court Name</th>
                                <th>Location</th>
                                <th>City</th>
                                <th>State</th>
                                <th>Courts Count</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    <tbody>
                        <!-- Data will be populated by DataTables -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@push('script')
<script>
$(document).ready(function() {
    // Always initialize DataTable
    var table = $('#myCourtsList').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('courts.my-courts') }}",
            type: 'GET',
            error: function(xhr, error, code) {
                console.log('DataTable AJAX Error:', xhr, error, code);
                alert('Error loading court data. Please check the console for details.');
            }
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'name', name: 'name' },
            { data: 'location', name: 'location' },
            { data: 'city', name: 'city' },
            { data: 'state', name: 'state' },
            { data: 'courts_count', name: 'courts_count', orderable: false, searchable: false },
            { data: 'status', name: 'status' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        order: [[6, 'desc']], // Order by created date
        pageLength: 10,
        responsive: true,
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
        language: {
            search: '<i class="bx bx-search"></i>',
            searchPlaceholder: 'Search courts...',
            paginate: {
                previous: '<i class="bx bx-chevron-left"></i>',
                next: '<i class="bx bx-chevron-right"></i>'
            },
            emptyTable: "No courts found in the system",
            zeroRecords: "No matching courts found"
        }
    });

    // Filter functions
    window.filterByStatus = function(status) {
        if (status === 'all') {
            table.column(5).search('').draw();
        } else if (status === 'active') {
            table.column(5).search('Active').draw();
        } else if (status === 'inactive') {
            table.column(5).search('Inactive').draw();
        }
    }
});

// Confirm delete function (if not already defined globally)
if (typeof confirmDelete === 'undefined') {
    function confirmDelete(route, id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{ route('courts.delete', '') }}" + "/" + id;
            }
        });
    }
}
</script>
@endpush
@endsection
