@extends('layouts.master')

@section('pageStyle')
<!-- Cropper.js CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">
<!-- Custom Court Advanced CSS -->
<link rel="stylesheet" href="{{ asset('assets/css/court-advanced.css') }}">
@endsection

@section('content')
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Header -->
        <div class="row">
            <div class="col-12">
                <h4 class="fw-bold py-3 mb-4">
                    <span class="text-muted fw-light">{{ $module_name }}/</span> Create Advanced Court
                </h4>
            </div>
        </div>

        <!-- Success/Error Messages -->
        @if(session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            <i class="bx bx-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger alert-dismissible" role="alert">
            <i class="bx bx-error-circle me-2"></i>
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <!-- Main Form -->
        <form action="{{ route('courts.create-advanced') }}" method="POST" enctype="multipart/form-data" id="courtForm">
            @csrf
            <div class="row">
                <!-- Left Column - Basic Information -->
                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="bx bx-info-circle me-2"></i>Basic Information
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Court Name -->
                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">
                                        Court Name <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="name" id="name"
                                           class="form-control @error('name') is-invalid @enderror"
                                           placeholder="Enter court name"
                                           value="{{ old('name') }}" required>
                                    @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Phone -->
                                <div class="col-md-6 mb-3">
                                    <label for="phone" class="form-label">Phone Number</label>
                                    <input type="tel" name="phone" id="phone"
                                           class="form-control @error('phone') is-invalid @enderror"
                                           placeholder="Enter phone number"
                                           value="{{ old('phone') }}">
                                    @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Email -->
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" name="email" id="email"
                                           class="form-control @error('email') is-invalid @enderror"
                                           placeholder="Enter email address"
                                           value="{{ old('email') }}">
                                    @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Website -->
                                <div class="col-md-6 mb-3">
                                    <label for="website" class="form-label">Website</label>
                                    <input type="url" name="website" id="website"
                                           class="form-control @error('website') is-invalid @enderror"
                                           placeholder="https://example.com"
                                           value="{{ old('website') }}">
                                    @error('website')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Description -->
                                <div class="col-12 mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" id="description" rows="3"
                                              class="form-control @error('description') is-invalid @enderror"
                                              placeholder="Enter court description">{{ old('description') }}</textarea>
                                    @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Location Information -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="bx bx-map me-2"></i>Location Information
                            </h5>
                        </div>
                        <div class="card-body">
                            <!-- Address with Google Places -->
                            <div class="mb-3">
                                <label for="location" class="form-label">
                                    Address <span class="text-danger">*</span>
                                    <small class="text-muted">(Start typing for suggestions)</small>
                                </label>
                                <input type="text" name="location" id="location"
                                       class="form-control @error('location') is-invalid @enderror"
                                       placeholder="Start typing your address..."
                                       value="{{ old('location') }}" required>
                                @error('location')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row">
                                <!-- Latitude -->
                                <div class="col-md-6 mb-3">
                                    <label for="latitude" class="form-label">
                                        Latitude <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="latitude" id="latitude"
                                           class="form-control @error('latitude') is-invalid @enderror"
                                           placeholder="Auto-filled from address"
                                           value="{{ old('latitude') }}" readonly required>
                                    @error('latitude')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Longitude -->
                                <div class="col-md-6 mb-3">
                                    <label for="longitude" class="form-label">
                                        Longitude <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="longitude" id="longitude"
                                           class="form-control @error('longitude') is-invalid @enderror"
                                           placeholder="Auto-filled from address"
                                           value="{{ old('longitude') }}" readonly required>
                                    @error('longitude')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- City -->
                                <div class="col-md-4 mb-3">
                                    <label for="city" class="form-label">
                                        City <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="city" id="city"
                                           class="form-control @error('city') is-invalid @enderror"
                                           placeholder="Auto-filled from address"
                                           value="{{ old('city') }}" readonly required>
                                    @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- State -->
                                <div class="col-md-4 mb-3">
                                    <label for="state" class="form-label">
                                        State <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="state" id="state"
                                           class="form-control @error('state') is-invalid @enderror"
                                           placeholder="Auto-filled from address"
                                           value="{{ old('state') }}" readonly required>
                                    @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- ZIP -->
                                <div class="col-md-4 mb-3">
                                    <label for="zip" class="form-label">
                                        ZIP Code <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="zip" id="zip"
                                           class="form-control @error('zip') is-invalid @enderror"
                                           placeholder="Auto-filled from address"
                                           value="{{ old('zip') }}" required>
                                    @error('zip')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Map Preview -->
                            <div class="mt-3">
                                <label class="form-label">Location Preview</label>
                                <div id="map" style="height: 300px; border-radius: 6px;" class="bg-light d-flex align-items-center justify-content-center">
                                    <div class="text-muted">
                                        <i class="bx bx-map-pin fs-1"></i>
                                        <p class="mt-2">Select an address to view location on map</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Additional Information -->
                <div class="col-lg-4">
                    <!-- Court Details -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="bx bx-detail me-2"></i>Court Details
                            </h5>
                        </div>
                        <div class="card-body">
                            <!-- Surface Type -->
                            <div class="mb-3">
                                <label for="surfaces" class="form-label">Surface Type</label>
                                <select name="surfaces" id="surfaces" class="form-select @error('surfaces') is-invalid @enderror">
                                    <option value="">Select Surface</option>
                                    <option value="Wood" {{ old('surfaces') == 'Wood' ? 'selected' : '' }}>Wood</option>
                                    <option value="Asphalt" {{ old('surfaces') == 'Asphalt' ? 'selected' : '' }}>Asphalt</option>
                                    <option value="Concrete" {{ old('surfaces') == 'Concrete' ? 'selected' : '' }}>Concrete</option>
                                </select>
                                @error('surfaces')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Number of Indoor Courts -->
                            <div class="mb-3">
                                <label for="no_indoor_courts" class="form-label">Indoor Courts</label>
                                <input type="number" name="no_indoor_courts" id="no_indoor_courts"
                                       class="form-control @error('no_indoor_courts') is-invalid @enderror"
                                       min="0" max="100" value="{{ old('no_indoor_courts', 0) }}">
                                @error('no_indoor_courts')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Number of Outdoor Courts -->
                            <div class="mb-3">
                                <label for="no_outdoor_courts" class="form-label">Outdoor Courts</label>
                                <input type="number" name="no_outdoor_courts" id="no_outdoor_courts"
                                       class="form-control @error('no_outdoor_courts') is-invalid @enderror"
                                       min="0" max="100" value="{{ old('no_outdoor_courts', 0) }}">
                                @error('no_outdoor_courts')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Amenities -->
                            <div class="mb-3">
                                <label class="form-label">Amenities</label>
                                <div class="row">
                                    @php
                                    $amenities = ['Food and Drinks', 'Locker Rooms', 'Restrooms', 'Water', 'Lighted Courts', 'Pro Shop', 'Trainers & Lessons', 'Wheelchair Accessibility'];
                                    @endphp
                                    @foreach($amenities as $amenity)
                                    <div class="col-6 mb-2">
                                                                                                                        <div class="form-check">
                                            @php
                                            $oldAmenities = old('amenities');
                                            $isChecked = false;
                                            if (is_array($oldAmenities)) {
                                                $isChecked = in_array($amenity, $oldAmenities);
                                            } elseif (is_string($oldAmenities) && !empty($oldAmenities)) {
                                                $isChecked = in_array($amenity, explode(',', $oldAmenities));
                                            }
                                            @endphp
                                            <input class="form-check-input" type="checkbox" name="amenities[]"
                                                   value="{{ $amenity }}" id="amenity_{{ $loop->index }}"
                                                   {{ $isChecked ? 'checked' : '' }}>
                                            <label class="form-check-label" for="amenity_{{ $loop->index }}">
                                                {{ $amenity }}
                                            </label>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>

                            <!-- Net Types -->
                            <div class="mb-3">
                                <label class="form-label">Net Types</label>
                                <div class="row">
                                    @php
                                    $netTypes = ['Permanent Net', 'Tennis Net', 'Bring Your Own Nets', 'Portable Nets'];
                                    @endphp
                                    @foreach($netTypes as $net)
                                    <div class="col-12 mb-2">
                                                                                                                        <div class="form-check">
                                            @php
                                            $oldNets = old('nets');
                                            $isChecked = false;
                                            if (is_array($oldNets)) {
                                                $isChecked = in_array($net, $oldNets);
                                            } elseif (is_string($oldNets) && !empty($oldNets)) {
                                                $isChecked = in_array($net, explode(',', $oldNets));
                                            }
                                            @endphp
                                            <input class="form-check-input" type="checkbox" name="nets[]"
                                                   value="{{ $net }}" id="net_{{ $loop->index }}"
                                                   {{ $isChecked ? 'checked' : '' }}>
                                            <label class="form-check-label" for="net_{{ $loop->index }}">
                                                {{ $net }}
                                            </label>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Image Upload -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="bx bx-image me-2"></i>Court Images
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="images" class="form-label">Upload Images</label>
                                <input type="file" name="images[]" id="images"
                                       class="form-control @error('images') is-invalid @enderror"
                                       multiple accept="image/*">
                                <small class="text-muted">Maximum 10 images, 5MB each. Supported: JPG, PNG, GIF</small>
                                @error('images')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Image Preview Area -->
                            <div id="imagePreviewContainer" class="row"></div>

                            <!-- Cropped Images Storage -->
                            <div id="croppedImagesContainer"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                                                <div class="card-body text-center">
                            <button type="submit" class="btn btn-primary btn-lg me-3" id="submitBtn">
                                <i class="bx bx-save me-2"></i>Create Court
                            </button>
                            <a href="{{ route('courts.my-courts') }}" class="btn btn-secondary btn-lg">
                                <i class="bx bx-arrow-back me-2"></i>Back to My Courts
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Image Crop Modal -->
<div class="modal fade" id="cropModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Crop Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="img-container">
                    <img id="cropImage" style="max-width: 100%;">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="cropBtn">Crop & Save</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<!-- Google Places API -->
<script src="https://maps.googleapis.com/maps/api/js?key={{ $google_api_key }}&libraries=places&callback=initMap" async defer></script>

<!-- Cropper.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>

<!-- Custom Court Advanced JavaScript -->
<script src="{{ asset('assets/js/court-advanced.js') }}"></script>

<script>
// Additional specific functionality can be added here if needed
</script>
@endsection
