@extends('layouts.master')

@section('content')
@if(session('success'))
    <div class="alert alert-primary alert-dismissible" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
        </button>
    </div>
@endif
<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4">
            <span class="text-muted fw-light">{{ $module_name }} /</span> Edit
        </h4>
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="card-body">
                        <form action="{{ route('settings.edit') }}" class="mb-3"
                            method="POST">
                            @csrf
                            <div>
                                <label for="defaultFormControlInput" class="form-label">Facebook</label>
                                <input name="facebook" type="text" class="form-control" id="defaultFormControlInput"
                                    value="{{ $facebook[0] }}" aria-describedby="defaultFormControlHelp" />
                                @if($errors->has('facebook'))
                                    <span
                                        class="text-danger">{{ $errors->first('facebook') }}</span>
                                @endif
                            </div>
                            <div>
                                <label for="defaultFormControlInput" class="form-label">instagram</label>
                                <input name="instagram" type="text" class="form-control" id="defaultFormControlInput"
                                    value="{{ $instagram[0] }}" aria-describedby="defaultFormControlHelp" />
                                @if($errors->has('instagram'))
                                    <span
                                        class="text-danger">{{ $errors->first('instagram') }}</span>
                                @endif
                            </div>
                            <div class="demo-inline-spacing">
                                <input type="submit" class="btn btn-primary move-right" value="Update" />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->

    @endsection

    @section('scripts')

    @endsection
