<!DOCTYPE html>

<html lang="en"
    data-assets-path="{{ asset('assets/') }}/" data-template="vertical-menu-template">

@include('auth.essentials.header')
<!-- Include Tagify CSS & JS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@yaireo/tagify/dist/tagify.css">
<script src="https://cdn.jsdelivr.net/npm/@yaireo/tagify"></script>

<body>
    @if(session('error'))
    <div class="alert alert-danger alert-dismissible" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
        </button>
    </div>
    @endif
    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <!--@include('auth.essentials.logo')-->
                        <!-- /Logo -->
                        <!--<h4 class="mb-2">Welcome to Sub-Admin! 👋</h4>-->
                        <h4 class="mb-2">Welcome to PBLinks</h4>
                        <!--<p class="mb-4">Make your app management easy and fun!</p>-->

                        <form class="mb-3" action="{{ route('register') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <!-- ---------------------------------User Fields---------------------------------------------- -->

                            <div class="mb-3">
                                <label for="name" class="form-label">Full Name</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    id="name" name="name" placeholder="Enter your Full name"
                                    value="{{ old('name') }}" autofocus>

                                @error('name')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="text" class="form-control @error('email') is-invalid @enderror"
                                    id="email" name="email" placeholder="Enter your email"
                                    value="{{ old('email') }}">

                                @error('email')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div>
                                <label for="" class="form-label">Profile Picture</label>
                                <input name="picture" type="file" class="form-control" />
                                @if($errors->has('picture'))
                                <span class="text-danger">{{ $errors->first('picture') }}</span>
                                @endif
                            </div>

                            <div class="mb-3 form-password-toggle">
                                <label class="form-label" for="password">Password</label>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password" class="form-control @error('password') is-invalid @enderror"
                                        name="password" placeholder="••••••••••••" aria-describedby="password" />

                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                                @error('password')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <!-- ---------------------------------Club Fields---------------------------------------------- -->

                            <div class="mb-3">
                                <label for="club_name" class="form-label">Club Name</label>
                                <input type="text" class="form-control @error('club_name') is-invalid @enderror"
                                    id="club_name" name="club_name" placeholder="Enter your Club name"
                                    value="{{ old('club_name') }}" autofocus>

                                @error('club_name')
                                <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="" class="form-label">logo</label>
                                <input name="logo" type="file" class="form-control"
                                    placeholder="New York" value="" />
                                @if($errors->has('logo'))
                                <span class="text-danger">{{ $errors->first('logo') }}</span>
                                @endif
                            </div>

                            <!-- jQuery (optional, only needed for the Enter key prevention script) -->
                            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

                            <!-- Google Maps JavaScript API -->
                            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBAY9jgE-CPAPcU78LqNJ6xquCX01LNcp4&libraries=places&callback=initialize" async> </script>
                            <script>
                                $(document).ready(function() {
                                    $(window).keydown(function(event) {
                                        if (event.keyCode === 13) {
                                            event.preventDefault();
                                            return false;
                                        }
                                    });
                                });

                                let map, marker, autocomplete;

                                function initialize() {
                                    initMap();
                                    initAutocomplete();
                                }

                                function initMap() {
                                    map = new google.maps.Map(document.getElementById('map'), {
                                        center: {
                                            lat: 40.749933,
                                            lng: -73.98633
                                        },
                                        zoom: 13
                                    });
                                }

                                function initAutocomplete() {
                                    autocomplete = new google.maps.places.Autocomplete(
                                        document.getElementById('autocomplete'), {
                                            types: ['geocode']
                                        }
                                    );
                                    autocomplete.addListener('place_changed', fillInAddress);
                                }

                                function fillInAddress() {
                                    const place = autocomplete.getPlace();
                                    if (!place.geometry) return;

                                    // Update map
                                    if (place.geometry.viewport) {
                                        map.fitBounds(place.geometry.viewport);
                                    } else {
                                        map.setCenter(place.geometry.location);
                                        map.setZoom(17);
                                    }

                                    if (marker) {
                                        marker.setMap(null);
                                    }

                                    marker = new google.maps.Marker({
                                        map: map,
                                        position: place.geometry.location
                                    });

                                    document.getElementById("latitude").value = place.geometry.location.lat();
                                    document.getElementById("longitude").value = place.geometry.location.lng();
                                    // document.getElementById("map").removeAttribute("hidden");
                                }

                                function geolocate() {
                                    if (navigator.geolocation) {
                                        navigator.geolocation.getCurrentPosition(function(position) {
                                            const geolocation = {
                                                lat: position.coords.latitude,
                                                lng: position.coords.longitude
                                            };
                                            const circle = new google.maps.Circle({
                                                center: geolocation,
                                                radius: position.coords.accuracy
                                            });
                                            autocomplete.setBounds(circle.getBounds());
                                        });
                                    }
                                }
                            </script>

                            <div class="mb-3">
                                <label for="" class="form-label">location</label>
                                <input class="form-control"
                                    type="text"
                                    name="location"
                                    id="autocomplete"
                                    onFocus="geolocate()"
                                    placeholder="Club Location"
                                    data-parsley-required-message="The restaurant address field is required"
                                    required>
                                @if($errors->has('location'))
                                <span class="text-danger">{{ $errors->first('location') }}</span>
                                @endif
                            </div>

                            <div class="mb-3">
                                <input class="form-control"
                                    type="hidden"
                                    name="latitude"
                                    id="latitude"
                                    placeholder="Latitude"
                                    required>
                            </div>

                            <div class="mb-3">
                                <input class="form-control"
                                    type="hidden"
                                    name="longitude"
                                    id="longitude"
                                    placeholder="Longitude"
                                    required>
                            </div>

                            <!-- Map Display -->
                            <div id="map" hidden style="width:100%;height:400px;"></div>

                            <div class="mb-3">
                                <label for="" class="form-label">State</label>
                                <input name="state" type="text" class="form-control"
                                    placeholder="Enter State" value="" />
                                @if($errors->has('state'))
                                <span class="text-danger">{{ $errors->first('state') }}</span>
                                @endif
                            </div>

                            <div class="mb-3">
                                <label for="" class="form-label">City</label>
                                <input name="city" type="text" class="form-control"
                                    placeholder="Enter City" value="" />
                                @if($errors->has('city'))
                                <span class="text-danger">{{ $errors->first('city') }}</span>
                                @endif
                            </div>
                            <div class="mb-3">
                                <label for="" class="form-label">Zip Code</label>
                                <input name="zip" type="text" class="form-control"
                                    placeholder="Zip Code" value="" />
                                @if($errors->has('zip'))
                                <span class="text-danger">{{ $errors->first('zip') }}</span>
                                @endif
                            </div>



                            <div class="mb-3">
                                <label for="exampleFormControlTextarea1" class="form-label">Description</label>
                                <textarea name="description" class="form-control" id="exampleFormControlTextarea1"
                                    rows="3" placeholder="We are please to announce that..."></textarea>
                                @if($errors->has('description'))
                                <span
                                    class="text-danger">{{ $errors->first('description') }}</span>
                                @endif
                            </div>

                            <div class="mb-3">
                                <label for="" class="form-label">Amenities</label>
                                <input class="form-control" name="amenities" id="amenities" placeholder="Type and press enter" />
                            </div>

                            <div class="mb-3">
                                <label for="" class="form-label">Surface and Features</label>
                                <input class="form-control" name="surface" id="surface" placeholder="Type and press enter" />
                            </div>

                            <div class="mb-3">
                                <label for="" class="form-label">Net and Lines</label>
                                <input class="form-control" name="net" id="net" placeholder="Type and press enter" />
                            </div>

                            <div class="mb-3">
                                <label for="" class="form-label">Total Courts</label>
                                <input name="total_courts" type="number" class="form-control"
                                    placeholder="4" value="" />
                                @if($errors->has('total_courts'))
                                <span class="text-danger">{{ $errors->first('total_courts') }}</span>
                                @endif
                            </div>

                            <div class="mb-3">
                                <button type="submit" class="btn btn-primary d-grid w-100">Sign up</button>
                            </div>
                        </form>

                        <p class="text-center">
                            <span>Already have an account?</span>
                            <a href="{{route('login')}}">
                                <span>Sign in instead</span>
                            </a>
                        </p>

                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>

    @include('auth.essentials.scripts')


</body>

</html>
<script>
    var amenities = document.getElementById('amenities');
    var amenitiesTagify = new Tagify(amenities);

    var surface = document.getElementById('surface');
    var surfaceTagify = new Tagify(surface);

    var net = document.getElementById('net');
    var netTagify = new Tagify(net);
</script>