<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('clubs', function (Blueprint $table) {
            $table->json('amenities')->after('total_courts')->nullable()->default(null);
            $table->json('surfaces')->after('amenities')->nullable()->default(null);
            $table->json('nets')->after('surfaces')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('clubs', function (Blueprint $table) {
            $table->dropColumn('amenities');
            $table->dropColumn('surfaces');
            $table->dropColumn('nets');
        });
    }
};
