<?php

namespace App\Observers;

use App\Models\User;
use Illuminate\Support\Facades\Log;

class UserObserver
{
    /**
     * Handle the User "created" event.
     */
    public function created(User $user): void
    {
        //
    }

    /**
     * Handle the User "updated" event.
     */
    public function updated(User $user): void
    {
        //
    }

    /**
     * Handle the User "deleted" event.
     */
    public function deleted(User $user): void
    {
        // Delete related records
        $user->clubs()->each(function ($club) {
            $club->delete();  // This will trigger the ClubObserver's deleted method
        });
        $user->devices()->delete();
        $user->favorites()->delete();
        $user->events()->detach();
        $user->tournaments()->delete();
        $user->comments()->delete();
        $user->ads()->delete();
        $user->reviews()->delete();
        $user->cards()->delete();
        $user->invitations()->delete();
        $user->posts()->each(function ($post) {
            $post->delete();  // This will trigger the PostObserver's deleted method
        });
        $user->activities()->delete();
    }

    /**
     * Handle the User "restored" event.
     */
    public function restored(User $user): void
    {
        //
    }

    /**
     * Handle the User "force deleted" event.
     */
    public function forceDeleted(User $user): void
    {
        //
    }
}
