<?php

namespace App\Observers;

use App\Models\Club;
use Illuminate\Support\Facades\Log;

class ClubObserver
{
    /**
     * Handle the Club "created" event.
     */
    public function created(Club $club): void
    {
        //
    }

    /**
     * Handle the Club "updated" event.
     */
    public function updated(Club $club): void
    {
        //
    }

    /**
     * Handle the Club "deleted" event.
     */
    public function deleted(Club $club): void
    {
        Log::info($club->name. ' is deleted');
        // Delete related records
        $club->workingHours()->delete();
        $club->courts()->delete();
        $club->events()->delete();
        $club->reservations()->delete();
        $club->tournaments()->delete();
    }

    /**
     * Handle the Club "restored" event.
     */
    public function restored(Club $club): void
    {
        //
    }

    /**
     * Handle the Club "force deleted" event.
     */
    public function forceDeleted(Club $club): void
    {
        //
    }
}
