<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WorkingHour extends Model
{
    use HasFactory, SoftDeletes;

    const DAYS = [
        '0' => 'SUNDAY',
        '1' => 'MONDAY',
        '2' => 'TUESDAY',
        '3' => 'WEDNESDAY',
        '4' => 'THURSDAY',
        '5' => 'FRIDAY',
        '6' => 'SATURDAY',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'club_id',
        'day', // 0: Sunday, 1: Monday, 2: Tuesday, 3: Wednesday, 4: Thursday, 5: Friday, 6: Saturday
        'opening_time',
        'closing_time',
        'status',
    ];

    /**
     * Get the club that owns the working hour.
     * 
     * @return BelongsTo
     */
    public function club(): BelongsTo
    {
        return $this->belongsTo(Club::class);
    }
}
