<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserFeed extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'sharable_type',
        'sharable_id',
        'status',
    ];

    public function sharable()
    {
        return $this->morphTo();
    }

    // public function user()
    // {
    //     return $this->hasOne(User::class, 'id', 'user_id');
    // }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
