<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserCard extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'stripe_source_id',
        'card_brand',
        'card_last4',
        'default_card',
        'card_holder',
        'card_expiry',
        'status'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }
}
