<?php

namespace App\Models;

use App\Models\Subscription;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'user_id','subscription_id','amount','payment_method','status','transaction_reference'
    ];

    function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    function subscription()
    {
        return $this->belongsTo(Subscription::class, 'subscription_id');
    }

}