<?php

namespace App\Models;

use App\Models\Package;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    protected $fillable = [
        'user_id','package_id','start_date','end_date','is_active'
    ];

    function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function isExpired()
    {
        return $this->end_date < now();
    }


    public function package()
    {
        return $this->belongsTo(Package::class);
    }
}
