<?php

namespace App\Models;

use App\Helpers\Strings;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Review extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'rateable_id',
        'rateable_type',
        'rating',
        'comment',
    ];

    /**
     * Booted method of the model
     */
    protected static function booted(): void
    {
        static::creating(function ($model) {
            $model->user_id = auth()->user()->id;
            $model->rateable_type = Strings::getType($model->rateable_type);
        });

        static::updating(function ($model) {
            $model->user_id = auth()->user()->id;
            $model->rateable_type = Strings::getType($model->rateable_type);
        });
    }

    /**
     * Get the user that owns the review
     *
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the rateable model that owns the review
     *
     * @return BelongsTo
     */
    public function rateable(): BelongsTo
    {
        return $this->morphTo();
    }

    /**
     * Get the rateable model that owns the review
     *
     * @return BelongsTo
     */
    public function club(): BelongsTo
    {
        return $this->belongsTo(Club::class, 'rateable_id');
    }

    /**
     * Get the rateable model that owns the review
     *
     * @return BelongsTo
     */
    // public function event(): BelongsTo
    // {
    //     return $this->belongsTo(Event::class, 'rateable_id');
    // }

    /**
     * Get the rateable model that owns the review
     *
     * @return BelongsTo
     */
    // public function tournament(): BelongsTo
    // {
    //     return $this->belongsTo(Tournament::class, 'rateable_id');
    // }
}
