<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Reservation extends Model
{
    use HasFactory, SoftDeletes;

    const DAYS = [
        '0' => 'SUNDAY',
        '1' => 'MONDAY',
        '2' => 'TUESDAY',
        '3' => 'WEDNESDAY',
        '4' => 'THURSDAY',
        '5' => 'FRIDAY',
        '6' => 'SATURDAY',
    ];

    const STATUS = [
        'pending' => 'Pending',
        'cancelled' => 'Cancelled',
        'accepted' => 'Accepted',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'club_id',
        'day',
        'start_time',
        'end_time',
        'reservation_date',
        'status'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        'reservation_date' => 'date',
    ];

    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::creating(function ($reservation) {
            $reservation->user_id = auth()->id();
        });

        static::updating(function ($reservation) {
            $reservation->user_id = auth()->id();
        });
    }

    /**
     * Get the user that owns the reservation.
     *
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the club that owns the reservation.
     *
     * @return BelongsTo
     */
    public function club(): BelongsTo
    {
        return $this->belongsTo(Club::class);
    }

    /**
     * Get the court that owns the reservation.
     *
     * @return BelongsTo
     */
    public function court(): BelongsTo
    {
        return $this->belongsTo(Court::class);
    }

    /**
     * Get the invitations that belong to the reservation.
     *
     * @return HasMany
     */
    public function invitations(): HasMany
    {
        return $this->hasMany(Invitation::class);
    }
}
