<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class React extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable
     *
     * @var array<string>
     */
    protected $fillable = [
        'uuid',
        'user_id',
        'type', // 0: like, 1: love, 2: care, 3: laugh, 4: wow, 5: cry, 6: angry
        'reactable_type', // post, comment etc
        'reactable_id'
    ];

    /**
     * The booted method of the model
     */
    protected static function booted()
    {
        static::creating(function (React $model) {
            $model->user_id = auth()->user()->id;
        });
    }

    /**
     * Retrieve associated user
     *
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Retrieve associated reactable
     *
     * @return MorphTo
     */
    public function reactable(): MorphTo
    {
        return $this->morphTo();
    }
}
