<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PostMedia extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'post_id',
        'type',
        'media'
    ];

    /**
     * Get the user's picture
     *
     * @return Attribute|null
     */
    protected function media(): ?Attribute
    {
        return new Attribute(
            get: fn ($value) => $value !== null ? env('UPLOAD_URL') . $value : null,
        );
    }
}
