<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CourtMedia extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'court_media';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'court_id',
        'file_name',
        'file_path',
        'file_type',
        'mime_type',
        'file_size',
        'is_primary',
        'status'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_primary' => 'boolean',
        'file_size' => 'integer',
    ];

    /**
     * Get the court that owns the media.
     *
     * @return BelongsTo
     */
    public function court(): BelongsTo
    {
        return $this->belongsTo(Court::class);
    }

    protected function filePath(): Attribute
    {
        return Attribute::make(
            get: fn($value) => $value != null ? config('app.uploads_url') . $value : null,
        );
    }
}
