<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckSubscription
{
    public function handle(Request $request, Closure $next)
    {
        if ($request->routeIs('buy.subscription')) {
            return $next($request); // skip check
        }
        
        $user = Auth::user();

        if ($user->hasRole('club')) {
            // Assuming you have a relation `subscription()` in the User model
            $subscription = $user->subscription;

            if (!$subscription || $subscription->isExpired()) {
                return redirect()->route('buy.subscription') // Change route as needed
                    ->with('error', 'Your subscription has expired or is missing. Please subscribe to continue.');
            }
        }

        return $next($request);
    }
}
