<?php

namespace App\Http\Controllers;

use App\Models\Club;
use App\Models\User;
use App\Models\UserClub;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;

class UserClubController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new UserClub();
        $this->data['module_name'] = 'Users';
        $this->data['view_directory'] = 'pages.club_users';
        $this->data['parent_named_route'] = 'club_users';
    }

    public function index(Request $request)
    {
        $data = UserClub::with('user', 'club')
            ->whereHas('club', function ($query) {
                $query->where('user_id', Auth::user()->id);
            })
            ->selectRaw('MAX(id) as id, user_id')  // Use an aggregate function.
            ->groupBy('user_id')  // Group by user_id to avoid duplicate users.
            ->get();


        // $data = UserClub::with(['club' => function ($query) {
        //     $query->where('user_id', Auth::user()->id);
        // }])->select('user_id') // Select distinct user IDs.
        //     ->distinct() // Ensure unique user records.
        //     ->get();

        if ($request->ajax()) {


            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('action', function ($row) {

                    $view = '<a href="' . route("club_users.view", ['id' => $row->user_id]) . '" class="edit btn btn-primary btn-sm btn-equal mb-1">View</a>&nbsp;';

                    // $delete = '<a href="#" onclick="confirmDelete(\'' . $this->data['parent_named_route'] . '\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';

                    return $view;
                })
                ->addColumn('location', function ($row) {
                    return $row->user->location;
                })
                ->addColumn('rank', function ($row) {
                    return $row->user->rank;
                })
                ->addColumn('phone', function ($row) {
                    return $row->user->phone;
                })
                ->addColumn('email', function ($row) {
                    return $row->user->email;
                })
                ->addColumn('name', function ($row) {
                    return $row->user->name;
                })
                ->addColumn('picture', function ($row) {
                    return '<img src="' . $row->user->picture . '" class="" width=100px" heigt=100px"/>';
                })
                ->rawColumns(['action', 'picture'])
                ->make(true);
        }

        $this->data['page'] =  'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function view(Request $request)
    {
        $user = User::find($request->id);
        $this->data['user'] = $user::withCount('devices')
            ->withCount('cards')
            ->withCount('posts')
            ->withCount('events')
            ->withCount('tournaments')
            ->withCount('reviews')
            ->with(['activities' => function ($query) {
                $query->take(5);
            }])
            ->find($request->id);

        $this->data['page'] = __FUNCTION__;

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function status($id)
    {
        $user = $this->module::find($id);
        $user->status = $user->status ? '0' : '1';
        $user->save();

        return redirect()->back()->with('success', $this->data['module_name'] . ' status updated successfully');
    }

    public function delete($id)
    {
        $user = $this->module::find($id);

        if ($user) {
            $user->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', 'User not found');
    }
}
