<?php

namespace App\Http\Controllers;

use App\Models\Ad;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class UserAdsController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Ad();
        $this->data['module_name'] = 'User Ad';
        $this->data['view_directory'] = 'pages.user-ad';
        $this->data['parent_named_route'] = 'ads';
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::with('user');

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('user', function ($row) {
                    return $row->user->name;
                })
                ->addColumn('media', function ($row) {
                    $media = 'Not Available';
                    if ($row->adMedia->isNotEmpty()) {
                        $media = "";
                        foreach ($row->adMedia as $value) {
                            if ($value->media) {
                                $media .= '<img src="' . $value->media . '" class="" width="40px" height="40px"/><br>';
                            } else {
                                $media .= '<p>Not Available</p>';
                            }
                        }
                    }
                    return $media;
                })
                ->addColumn('action', function ($row) {

                    $view = '<a href="' . route("ads.view", ['id' => $row->id]) . '" class="edit btn btn-primary btn-sm btn-equal mb-1">View</a>&nbsp;';

                    // $edit = '<a href="' . route("ads.edit", ['id' => $row->id]) . '" class="edit btn btn-primary btn-sm">Edit</a>&nbsp;';
                    // if ($row->status) {
                    //     $status = '<a href="' . route("ads.status", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm">Deactivate</a>';
                    // } else {
                    //     $status = '<a href="' . route("ads.status", ['id' => $row->id]) . '" class="edit btn btn-success btn-sm">Activate</a>';
                    // }

                    // $delete = '<a href="' . route("ads.delete", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm">Delete</a>';
                    $delete = '<a href="#" onclick="confirmDelete(\'' . $this->data['parent_named_route'] . '\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';

                    return $view . $delete;
                })
                ->addColumn('status', function ($row) {
                    switch ($row->status) {
                        case 0:
                            return '<i style="color:orange;" class="menu-icon tf-icons bx bx-time-five"></i> Pending';
                        case 1:
                            return '<i style="color:green;" class="menu-icon tf-icons bx bx-user-check"></i> Active';
                        case 2:
                            return '<i style="color:gray;" class="menu-icon tf-icons bx bx-user-x"></i> Inactive';
                        case 3:
                            return '<i style="color:blue;" class="menu-icon tf-icons bx bx-flag"></i> Expired';
                        case 4:
                            return '<i style="color:red;" class="menu-icon tf-icons bx bx-x-circle"></i> Cancelled';
                        default:
                            return '<i style="color:black;" class="menu-icon tf-icons bx bx-question-mark"></i> Unknown';
                    }
                })

                ->rawColumns(['action', 'status', 'user', 'media'])
                ->make(true);
        }

        $this->data['page'] = 'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function edit(Request $request)
    {
        if ($request->isMethod('post')) {
            $validatedData = $request->validate([
                'title' => 'required|string',
                'description' => 'required|string',
                'cost' => 'required|integer|min:1',
                'days' => 'required|integer|min:1',
                'status' => 'required',
                'privacy' => 'required',
            ]);

            $this->module->where('id', $request->id)->update($validatedData);

            return redirect()->back()->with('success', $this->data['module_name'] . ' updated successfully');
        }

        $this->data['ads'] = $this->module::with('user')->find($request->id);

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function view(Request $request)
    {

        $this->data['ads'] = $this->module::with('user')->find($request->id);
        $this->data['page'] = __FUNCTION__;

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function status($id)
    {
        $ad = $this->module::find($id);
        $ad->status = $ad->status ? '0' : '1';
        $ad->save();

        return redirect()->back()->with('success', $this->data['module_name'] . ' status updated successfully');
    }

    public function delete($id)
    {
        $exprerience = $this->module::find($id);

        if ($exprerience) {
            $exprerience->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', 'Exprerience not found');
    }
}
