<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Yajra\DataTables\Facades\DataTables;

class RoleController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Role();
        $this->data['module_name'] = 'Role';
        $this->data['view_directory'] = 'pages.role';
        $this->data['parent_named_route'] = 'roles';
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::query();

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) use (&$sno) {
                    return $sno++;
                })
                ->addColumn('action', function ($row) {
                    $delete = '<a href="#" onclick="confirmDelete(\'' . $this->data['parent_named_route'] . '\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';
                    // $delete = '<a href="' . route($this->data['parent_named_route'] . ".delete", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';
                    $edit = '<a href="' . route($this->data['parent_named_route'] . ".edit", ['id' => $row->id]) . '" class="edit btn btn-info btn-sm btn-equal mb-1">Edit</a>';
                    return $delete . $edit;
                })

                ->addColumn('created_at', function ($row) {

                    return $row->created_at ? customDateFormat($row->created_at) : '-';
                })
                ->rawColumns(['action', 'created_at'])
                ->make(true);
        }

        $this->data['page'] =  'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->validate($request, [
                'name' => 'required|unique:roles,name',
                'permission' => 'required',
            ]);

            $role = Role::create(['name' => strtolower($request->input('name'))]);
            $role->syncPermissions($request->input('permission'));

            return redirect()->route($this->data['parent_named_route'] . '.index')->with('success', $this->data['module_name'] . ' created successfully');
        }

        $this->data['permissions'] = Permission::all();
        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function edit(Request $request, $id)
    {
        if ($request->isMethod('post')) {
            $this->validate($request, [
                'name' => 'required',
                'permission' => 'required',
            ]);

            $role = Role::find($id);
            $role->name = $request->input('name');
            $role->save();

            $role->syncPermissions($request->input('permission'));

            return redirect()->route($this->data['parent_named_route'].'.index')->with('success', $this->data['module_name'] . ' updated successfully');
        }

        $this->data['role'] = Role::find($id);
        $this->data['permissions'] = Permission::get();
        $this->data['rolePermissions'] = DB::table("role_has_permissions")->where("role_has_permissions.role_id", $id)
            ->pluck('role_has_permissions.permission_id', 'role_has_permissions.permission_id')
            ->all();

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function delete($id)
    {
        $announcement = $this->module::find($id);

        if ($announcement) {
            $announcement->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', $this->data['module_name'] . ' not found');
    }
}
