<?php

namespace App\Http\Controllers;

use App\Models\Post;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;

class PostsController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Post();
        $this->data['module_name'] = 'Post';
        $this->data['view_directory'] = 'pages.post';
        $this->data['parent_named_route'] = 'posts';
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::with('user');

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('action', function ($row) {

                    $view = '<a href="' . route($this->data['parent_named_route'] . ".view", ['id' => $row->id]) . '" class="edit btn btn-primary btn-sm btn-equal mb-1">View</a>&nbsp;';

                    // $delete = '<a href="' . route($this->data['parent_named_route'].".delete", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';
                    $delete = '<a href="#" onclick="confirmDelete(\'' . $this->data['parent_named_route'] . '\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';

                    return $view . $delete;
                })
                ->addColumn('user_name', function ($row) {

                    $user_name =  $row->user->name;

                    return $user_name;
                })
                ->addColumn('parent_post', function ($row) {

                    return $row->sharedPost ? $row->sharedPost->text : 'No Parent';
                })
                ->addColumn('view_comments', function ($row) {
                    if($row->comments->isNotEmpty()){
                        return '<a href="' . route('comments.index', ['post_id' => $row->id]) . '">View Comments</a>';
                    }
                    return 'No Comment Yet';
                })
                ->addColumn('media', function ($row) {
                    $mediaHtml = 'Not Available';

                    if ($row->media->isNotEmpty()) {
                        $mediaHtml = "";

                        foreach ($row->media as $value) {
                            if ($value->media) {
                                $mediaUrl = $value->media;
                                $extension = Str::afterLast($mediaUrl, '.');
                                $imageExtensions = ['jpg', 'jpeg', 'JPG', 'png', 'gif'];
                                $videoExtensions = ['mp4', 'webm', 'ogg'];

                                if (in_array($extension, $imageExtensions)) {
                                    $mediaHtml .= '<img src="' . $mediaUrl . '" class="img-fluid" style="max-width: 100px; max-height: 100px;"/><br>';
                                } elseif (in_array($extension, $videoExtensions)) {
                                    // Display a placeholder or thumbnail for the video
                                    $mediaHtml .= '<img src="https://via.placeholder.com/100x100?text=Video" class="img-fluid" style="max-width: 100px; max-height: 100px;" alt="Video Thumbnail"/><br>';
                                } else {
                                    $mediaHtml .= '<p>Unsupported media type</p>';
                                }
                            } else {
                                $mediaHtml .= '<p>Not Available</p>';
                            }
                        }
                    }

                    return $mediaHtml;
                })

                ->rawColumns(['action', 'user_name', 'view_comments', 'parent_post', 'media'])
                ->make(true);
        }

        $this->data['page'] =  'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function view(Request $request)
    {
        $this->data['post'] = $this->module::with('media', 'sharedPost', 'comments', 'reacts', 'user')->find($request->id);

        $this->data['page'] = __FUNCTION__;

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function delete($id)
    {
        $record = $this->module::find($id);

        if ($record) {
            $record->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', $this->data['module_name'] . ' not found');
    }
}
