<?php

namespace App\Http\Controllers;

use App\Models\Activity;
use App\Models\Ad;
use App\Models\Announcement;
use App\Models\Club;
use App\Models\Comment;
use App\Models\Contact;
use App\Models\Conversation;
use App\Models\Court;
use App\Models\Event;
use App\Models\Feature;
use App\Models\Group;
use App\Models\Invitation;
use App\Models\Post;
use App\Models\Reservation;
use App\Models\Tournament;
use App\Models\User;
use App\Models\UserDevice;
use App\Models\WorkingHour;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $module, $data = [];

    public function __construct()
    {
        $this->data['module_name'] = 'Dashboard';
        $this->data['view_directory'] = 'pages.dashboard';
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        if (auth()->user()->hasRole('club')) {

            $user = auth()->user();

            $this->data['dashboard']['clubs'] = $user->clubs->count();
            // $this->data['dashboard']['courts'] = $user->clubs->sum(function ($club) {
            //     return $club->courts->count();
            // });
            $this->data['dashboard']['courts'] = $user->clubs->sum(function ($club) {
                return $club->total_courts;
            });

            $this->data['dashboard']['events'] =  $user->events->count();

            // $this->data['dashboard']['invitations'] = $user->clubs->sum(function ($club) {
            //     return $club->reservations->sum(function ($reservation) {
            //         return $reservation->invitations->count();
            //     });
            // });

            $this->data['dashboard']['tournaments'] = $user->clubs->sum(function ($club) {
                return $club->tournaments->count();
            });
            $this->data['dashboard']['reservation'] = $user->clubs->sum(function ($club) {
                return $club->reservations->count();
            });
            $this->data['dashboard']['working days'] = $user->clubs->sum(function ($club) {
                return $club->workingHours->count();
            });
        } else {
            $this->data['dashboard']['users'] = User::count();
            $this->data['dashboard']['clubs'] = Club::count();
            $this->data['dashboard']['courts'] = Court::count();
            $this->data['dashboard']['events'] = Event::count();
            $this->data['dashboard']['features'] = Feature::count();
            $this->data['dashboard']['groups'] = Group::count();
            $this->data['dashboard']['invitations'] = Invitation::count();
            $this->data['dashboard']['tournaments'] = Tournament::count();
            $this->data['dashboard']['conversations'] = Conversation::count();
            $this->data['dashboard']['activities'] = Activity::count();
            $this->data['dashboard']['feedbacks'] = Contact::count();
            $this->data['dashboard']['posts'] = Post::count();
            $this->data['dashboard']['comments'] = Comment::count();
            $this->data['dashboard']['ads'] = Ad::count();
            $this->data['dashboard']['devices'] = UserDevice::count();
            $this->data['dashboard']['announcement'] = Announcement::count();
            $this->data['dashboard']['reservation'] = Reservation::count();
            $this->data['dashboard']['hours'] = WorkingHour::count();
        }


        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }
}
