<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class FeedbacksController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Contact();
        $this->data['module_name'] = 'Contact Us';
        $this->data['view_directory'] = 'pages.feedback';
        $this->data['parent_named_route'] = 'contact';
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::query();

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) use (&$sno) {
                    return $sno++;
                })
                ->addColumn('action', function ($row) {

                    $view = '<button type="button" class="btn btn-primary" onclick="showFeedback(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ')">Show</button>';

                    return $view;
                })

                ->addColumn('message', function ($row) {
                    return strlen($row->message) > 20 ? substr($row->message, 0, 20) . '...' : $row->message;
                })
                ->rawColumns(['action', 'message'])
                ->make(true);
        }

        $this->data['page'] = 'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }
}
