<?php

namespace App\Http\Controllers;

use App\Models\Feature;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class FeatureController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Feature();
        $this->data['module_name'] = 'Feature';
        $this->data['view_directory'] = 'pages.feature';
        $this->data['parent_named_route'] = 'features';
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::query();

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('action', function ($row) {

                    $edit = '<a href="' . route("features.edit", ['id' => $row->id]) . '" class="edit btn btn-info btn-sm btn-equal mb-1">Edit</a>&nbsp;';

                    if ($row->status) {
                        $status = '<a href="' . route("features.status", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm btn-equal mb-1">Deactivate</a>';
                    } else {
                        $status = '<a href="' . route("features.status", ['id' => $row->id]) . '" class="edit btn btn-success btn-sm btn-equal mb-1">Activate</a>';
                    }

                    $delete = '<a href="#" onclick="confirmDelete(\'' . $this->data['parent_named_route'] . '\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';

                    return $edit . $status . $delete;
                })
                ->addColumn('status', function ($row) {
                    return $row->status
                        ? '<i style="color:green;" class="menu-icon tf-icons bx bx-user-check"></i> Active'
                        : '<i style="color:red;" class="menu-icon tf-icons bx bx-user-x"></i> Inactive';
                })
                ->rawColumns(['action', 'status'])
                ->make(true);
        }

        $this->data['page'] =  'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->validate($request, [
                'name' => 'required|string|max:255',
                'status' => 'required|boolean',
            ]);

            $input = $request->all();
            $this->module::create($input);

            return redirect()->route($this->data['parent_named_route'] . '.index')->with('success', $this->data['module_name'] . ' created successfully');
        }

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function edit(Request $request, $id)
    {
        if ($request->isMethod('post')) {

            $this->validate($request, [
                'name' => 'required|string|max:255',
                'status' => 'required|boolean',
            ]);

            $input = $request->except('_token');
            $this->module::where('id', $id)->update($input);

            return redirect()->route($this->data['parent_named_route'] . '.index')->with('success', $this->data['module_name'] . ' updated successfully');
        }

        $this->data['feature'] = $this->module::find($id);

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function status($id)
    {
        $user = $this->module::find($id);
        $user->status = $user->status ? '0' : '1';
        $user->save();

        return redirect()->back()->with('success', $this->data['module_name'] . ' status updated successfully');
    }

    public function delete($id)
    {
        $user = $this->module::find($id);

        if ($user) {
            $user->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', 'User not found');
    }
}
