<?php

namespace App\Http\Controllers;

use App\Models\Content;
use Illuminate\Http\Request;

class ContentController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Content();
        $this->data['module_name'] = 'Content';
        $this->data['view_directory'] = 'pages.content';
        $this->data['parent_named_route'] = 'cms';
    }

    public function cms(Request $request)
    {
        if ($request->isMethod('post')) {
            $prefix = '';
            switch ($request->slug) {
                case 'about-us':
                    $prefix = 'about_us_';
                    break;
                case 'privacy-policy':
                    $prefix = 'privacy_policy_';
                    break;
                case 'terms-conditions':
                    $prefix = 'terms_conditions_';
                    break;
                case 'rules':
                    $prefix = 'rules_';
                    break;
                default:
                    break;
            }

            // Validate and prepare data for update
            $validatedData = $request->validate([
                $prefix . 'name' => 'required|string',
                $prefix . 'body' => 'required|string',
                // $prefix . 'image' => 'required|string',
            ]);

            // Remove the prefix from validated data keys
            $updatedData = [];
            foreach ($validatedData as $key => $value) {
                $updatedData[str_replace($prefix, '', $key)] = $value;
            }

            // Update database after removing prefix from keys
            $this->module->where('slug', $request->slug)->update($updatedData);

            return redirect()->back()->with('success', ucfirst($request->slug) . ' updated successfully');
        }

        // Fetch data for the view if not submitting form
        $this->data['about_us'] = $this->module::where('slug', 'about-us')->first();
        $this->data['privacy_policy'] = $this->module::where('slug', 'privacy-policy')->first();
        $this->data['terms_conditions'] = $this->module::where('slug', 'terms-conditions')->first();
        $this->data['rules'] = $this->module::where('slug', 'rules')->first();

        // Return the view with data
        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function settings(Request $request)
    {
        if ($request->isMethod('post')) {
            $validatedData = $request->validate([
                'facebook' => 'required|url',
                'instagram' => 'required|url',
            ]);

            $this->module->where('slug', 'facebook')->update([
                'url' => $validatedData['facebook'],
                'body' => $validatedData['facebook']
            ]);
            $this->module->where('slug', 'instagram')->update([
                'url' => $validatedData['instagram'],
                'body' => $validatedData['instagram']
            ]);

            return redirect()->back()->with('success', $this->data['module_name'] . ' updated successfully');
        }

        $this->data['facebook'] = $this->module::where('slug', 'facebook')->pluck('url');
        $this->data['instagram'] = $this->module::where('slug', 'instagram')->pluck('url');

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }
}
