<?php

namespace App\Http\Controllers;

use App\Models\Comment;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class CommentController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Comment();
        $this->data['module_name'] = 'Comments';
        $this->data['view_directory'] = 'pages.comment';
        $this->data['parent_named_route'] = 'comments';
    }

    public function index(Request $request, $post_id)
    {
        if ($request->ajax()) {

            $data = $this->module::with('user')->where('commentable_type', 'App\Models\Post')->where('commentable_id', $post_id)->where('parent_id', null);

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('action', function ($row) {

                    $view = '<a href="' . route($this->data['parent_named_route'] . ".view", ['id' => $row->id]) . '" class="edit btn btn-primary btn-sm btn-equal mb-1">View</a>&nbsp;';

                    // $delete = '<a href="' . route($this->data['parent_named_route'] . ".delete", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';
                    $delete = '<a href="#" onclick="confirmDelete(\'' . $this->data['parent_named_route'] . '\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';

                    return $view . $delete;
                })
                ->addColumn('user_name', function ($row) {

                    $user_name =  $row->user->name;

                    return $user_name;
                })
                ->rawColumns(['action', 'user_name'])
                ->make(true);
        }

        $this->data['page'] =  'List';
        $this->data['post_id'] =  $post_id;

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function view(Request $request)
    {
        $this->data['comment'] = $this->module::with('parent', 'user')->find($request->id);

        $this->data['page'] = __FUNCTION__;

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function delete($id)
    {
        $record = $this->module::find($id);

        if ($record) {
            $record->children()->delete();
            $record->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', $this->data['module_name'] . ' not found');
    }
}
