<?php

namespace App\Http\Controllers;

use App\Models\BusinessSetting;
use Illuminate\Http\Request;

class BusinessSettingsController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new BusinessSetting();
        $this->data['module_name'] = 'Business Settings';
        $this->data['view_directory'] = 'pages.business-setting';
    }

    public function edit(Request $request)
    {
        if ($request->isMethod('post')) {
            $validatedData = $request->validate([
                'reach_rate' => 'required|integer|min:1',
                'ads_rate' => 'required|integer|min:1',
                'engagament_rate' => 'required|integer|min:1',
            ]);

            $this->module->where('type', 'reach_rate')->update(['value' => $validatedData['reach_rate']]);
            $this->module->where('type', 'ads_rate')->update(['value' => $validatedData['ads_rate']]);
            $this->module->where('type', 'engagament_rate')->update(['value' => $validatedData['engagament_rate']]);

            return redirect()->back()->with('success', $this->data['module_name'] . ' updated successfully');
        }

        $this->data['reach_rate'] = $this->module::where('type', 'reach_rate')->pluck('value');
        $this->data['ads_rate'] = $this->module::where('type', 'ads_rate')->pluck('value');
        $this->data['engagament_rate'] = $this->module::where('type', 'engagament_rate')->pluck('value');

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function cms(Request $request)
    {
        if ($request->isMethod('post')) {
            $prefix = '';
            switch ($request->type) {
                case 'about-us':
                    $prefix = 'about_us_';
                    break;
                case 'privacy-policy':
                    $prefix = 'privacy_policy_';
                    break;
                case 'terms-conditions':
                    $prefix = 'terms_conditions_';
                    break;
                default:
                    break;
            }

            // Validate and prepare data for update
            $validatedData = $request->validate([
                $prefix . 'title' => 'required|string',
                $prefix . 'value' => 'required|string',
                $prefix . 'meta_title' => 'nullable|string',
                $prefix . 'meta_keyword' => 'nullable|string',
                $prefix . 'meta_description' => 'nullable|string',
                $prefix . 'status' => 'nullable|string',
            ]);

            // Remove the prefix from validated data keys
            $updatedData = [];
            foreach ($validatedData as $key => $value) {
                $updatedData[str_replace($prefix, '', $key)] = $value;
            }

            // Update database after removing prefix from keys
            $this->module->where('type', $request->type)->update($updatedData);

            return redirect()->back()->with('success', ucfirst($request->type) . ' updated successfully');
        }

        // Fetch data for the view if not submitting form
        $this->data['about_us'] = $this->module::where('type', 'about-us')->first();
        $this->data['privacy_policy'] = $this->module::where('type', 'privacy-policy')->first();
        $this->data['terms_conditions'] = $this->module::where('type', 'terms-conditions')->first();

        // Return the view with data
        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }
}
