<?php

namespace App\Http\Controllers;

use App\Events\SendAction;
use App\Models\Announcement;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Yajra\DataTables\Facades\DataTables;

class AnnouncementsController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Announcement();
        $this->data['module_name'] = 'Announcement';
        $this->data['view_directory'] = 'pages.announcement';
        $this->data['parent_named_route'] = 'announcements';

        // $this->middleware(['permission:announcement-list|announcement-create|announcement-edit|announcement-delete'], ['only' => ['index', 'show']]);
        // $this->middleware(['permission:announcement-create'], ['only' => ['create', 'store']]);
        // $this->middleware(['permission:announcement-edit'], ['only' => ['edit', 'update']]);
        // $this->middleware(['permission:announcement-delete'], ['only' => ['destroy', 'delete']]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::query();

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('action', function ($row) {
                    // $delete = '<a href="' . route("announcements.delete", ['id' => $row->id]) . '" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';
                    $delete = '<a href="#" onclick="confirmDelete(\'announcements\', ' . $row->id . ')" class="edit btn btn-danger btn-sm btn-equal mb-1">Delete</a>';
                    return $delete;
                })

                ->addColumn('created_at', function ($row) {

                    return $row->created_at ? customDateFormat($row->created_at) : '-';
                })
                ->rawColumns(['action', 'created_at'])
                ->make(true);
        }

        $this->data['page'] =  'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $validatedData = $request->validate([
                'title'       => 'required|string',
                'description' => 'required|string',
            ]);

            $announcement = $this->module->create($validatedData);

            $superAdminRoleId = Role::where('name', 'super admin')->first()->id;

            $users = User::where('id', '!=', $superAdminRoleId)
                ->get(['id'])
                ->pluck('id');
            event(new SendAction($users->toArray(), ['App\Models\User'], [
                'title' => 'Announcement',
                'body' => $request->description,
                'object_id' =>  $announcement->id,
                'object' => get_class($announcement),
                'actor_id' => auth()->user()->id,
                'type' => 'Announcement',
                'cron' => 0,
            ], true, true));

            return redirect()->route('announcements.index')->with('success', $this->data['module_name'] . ' added successfully');
        }
        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }

    public function delete($id)
    {
        $announcement = $this->module::find($id);

        if ($announcement) {
            $announcement->delete();

            return redirect()->back()->with('success', $this->data['module_name'] . ' deleted successfully');
        }

        return redirect()->back()->with('error', $this->data['module_name'] . ' not found');
    }
}
