<?php

namespace App\Http\Controllers;

use App\Models\Activity;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ActivityController extends Controller
{
    protected $module, $data = [];

    public function __construct()
    {
        $this->module = new Activity();
        $this->data['module_name'] = 'Activity';
        $this->data['view_directory'] = 'pages.activity';
        $this->data['parent_named_route'] = 'activities';
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->module::with('user', 'actor');

            // $sno = 1;
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('sno', function ($row) {
                    static $index = 0; // Static variable to keep track of the index
                    $page = request()->get('start', 0); // Get the start parameter
                    $index++;
                    return $page + $index;
                })
                ->addColumn('to', function ($row) {
                    return $row->user->name;
                })
                ->addColumn('from', function ($row) {
                    return $row->actor->name;
                })
                ->rawColumns(['to', 'from'])
                ->make(true);
        }

        $this->data['page'] = 'List';

        return view($this->data['view_directory'] . '.' . __FUNCTION__, $this->data);
    }
}
